/*
 * Decompiled with CFR 0.152.
 */
package io.github.fabricators_of_create.porting_lib.transfer.item;

import io.github.fabricators_of_create.porting_lib.transfer.TransferUtil;
import io.github.fabricators_of_create.porting_lib.transfer.item.SlottedStackStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.SlottedStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleSlotStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import org.jetbrains.annotations.NotNull;

public class SlotItemHandler
extends class_1735 {
    private static final class_1263 emptyInventory = new class_1277(0);
    private final SlottedStorage<ItemVariant> storage;
    private final int index;

    public SlotItemHandler(SlottedStackStorage storage, int index, int xPosition, int yPosition) {
        super(emptyInventory, index, xPosition, yPosition);
        this.storage = storage;
        this.index = index;
    }

    public SlotItemHandler(SlottedStorage<ItemVariant> storage, int index, int xPosition, int yPosition) {
        super(emptyInventory, index, xPosition, yPosition);
        this.storage = storage;
        this.index = index;
    }

    public boolean method_7680(class_1799 stack) {
        if (stack.method_7960()) {
            return false;
        }
        SlottedStorage<ItemVariant> slottedStorage = this.storage;
        if (slottedStorage instanceof SlottedStackStorage) {
            SlottedStackStorage slottedStorage2 = (SlottedStackStorage)slottedStorage;
            return slottedStorage2.isItemValid(this.index, ItemVariant.of((class_1799)stack), stack.method_7947());
        }
        return true;
    }

    @NotNull
    public class_1799 method_7677() {
        SlottedStorage<ItemVariant> slottedStorage = this.storage;
        if (slottedStorage instanceof SlottedStackStorage) {
            SlottedStackStorage slottedStorage2 = (SlottedStackStorage)slottedStorage;
            return slottedStorage2.getStackInSlot(this.index);
        }
        SingleSlotStorage slot = this.storage.getSlot(this.index);
        return ((ItemVariant)slot.getResource()).toStack((int)slot.getAmount());
    }

    public void method_7673(@NotNull class_1799 stack) {
        SlottedStorage<ItemVariant> slottedStorage = this.storage;
        if (slottedStorage instanceof SlottedStackStorage) {
            SlottedStackStorage slottedStorage2 = (SlottedStackStorage)slottedStorage;
            slottedStorage2.setStackInSlot(this.index, stack);
        } else {
            ItemVariant variant;
            SingleSlotStorage slot = this.storage.getSlot(this.index);
            if (!slot.isResourceBlank()) {
                try (Transaction t = TransferUtil.getTransaction();){
                    slot.extract((Object)((ItemVariant)slot.getResource()), slot.getAmount(), (TransactionContext)t);
                    t.commit();
                }
            }
            if (!(variant = ItemVariant.of((class_1799)stack)).isBlank()) {
                try (Transaction t = TransferUtil.getTransaction();){
                    slot.insert((Object)variant, (long)stack.method_7947(), (TransactionContext)t);
                    t.commit();
                }
            }
        }
        this.method_7668();
    }

    public void method_7670(@NotNull class_1799 oldStackIn, @NotNull class_1799 newStackIn) {
    }

    public int method_7675() {
        SlottedStorage<ItemVariant> slottedStorage = this.storage;
        if (slottedStorage instanceof SlottedStackStorage) {
            SlottedStackStorage slottedStorage2 = (SlottedStackStorage)slottedStorage;
            return slottedStorage2.getSlotLimit(this.index);
        }
        return (int)this.storage.getSlot(this.index).getCapacity();
    }

    public int method_7676(@NotNull class_1799 stack) {
        SlottedStorage<ItemVariant> slottedStorage = this.storage;
        if (slottedStorage instanceof SlottedStackStorage) {
            SlottedStackStorage slottedStorage2 = (SlottedStackStorage)slottedStorage;
            return slottedStorage2.getSlotLimit(this.index);
        }
        return (int)this.storage.getSlot(this.index).getCapacity();
    }

    public boolean method_7674(@NotNull class_1657 playerIn) {
        SlottedStorage<ItemVariant> slottedStorage = this.storage;
        if (slottedStorage instanceof SlottedStackStorage) {
            SlottedStackStorage slottedStorage2 = (SlottedStackStorage)slottedStorage;
            return !slottedStorage2.getStackInSlot(this.index).method_7960();
        }
        return !this.storage.getSlot(this.index).isResourceBlank();
    }

    @NotNull
    public class_1799 method_7671(int amount) {
        SlottedStorage<ItemVariant> slottedStorage = this.storage;
        if (slottedStorage instanceof SlottedStackStorage) {
            SlottedStackStorage slottedStorage2 = (SlottedStackStorage)slottedStorage;
            class_1799 held = slottedStorage2.getStackInSlot(this.index).method_7972();
            class_1799 removed = held.method_7971(amount);
            slottedStorage2.setStackInSlot(this.index, held);
            return removed;
        }
        try (Transaction t = TransferUtil.getTransaction();){
            SingleSlotStorage slot = this.storage.getSlot(this.index);
            class_1799 lastResource = ((ItemVariant)slot.getResource()).toStack();
            long extraced = slot.extract((Object)((ItemVariant)slot.getResource()), (long)amount, (TransactionContext)t);
            t.commit();
            class_1799 class_17992 = lastResource.method_46651((int)extraced);
            return class_17992;
        }
    }

    public SlottedStorage<ItemVariant> getItemHandler() {
        return this.storage;
    }
}

